 <?php $__env->startSection('content'); ?>
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								<?php echo e(__('attendance.title')); ?>

							</h3>
						</div>
						<div class="card-body">
							<div id="js-search-form">
								<form method="post" action="<?php echo e(route('attendance.create')); ?>">
									<?php echo e(csrf_field()); ?>

									<div class="row">
										<div class="col-md-4">
											<div class="form-group">
												<label for="date"><?php echo e(__('attendance.attendance_date')); ?></label>
												<input type="date" value="<?php echo e($date); ?>" class="form-control" name="date"
													id="js-attendance-date">
											</div>
										</div>
										<div class="col-md-4">
											<div class="form-group">
												<label for="search"><?php echo e(__('attendance.search_member')); ?></label>
												<input type="text" placeholder="<?php echo e(__('attendance.ph_search')); ?>"
													class="form-control" name="search" id="search">
											</div>
										</div>
										<div class="col-md-4 d-flex align-items-end">
											<div class="form-group">
												<button type="submit" class="d-block btn btn-primary"><?php echo e(__('attendance.search_member')); ?></button>
											</div>
										</div>
									</div>
								</form>
							</div>
							<div id="js-attendance-form" class="d-none">
								<form method="post" action="<?php echo e(route('attendance.store_manual')); ?>">
									<?php echo e(csrf_field()); ?>

									<div class="row">
										<div class="col-md-4">
											<div class="form-group">
												<label for="date"><?php echo e(__('attendance.attendance_date')); ?></label>
												<input type="date" value="<?php echo e($date); ?>" class="form-control" name="date"
													id="js-attendance-date">
											</div>
										</div>
										<div class="col-md-4">
											<div class="form-group">
												<label for="date"><?php echo e(__('attendance.attendance_status')); ?></label>
												<select class="form-control" name="status">
													<option value="present">Present</option>
													<option value="absent">Absent</option>
												</select>
												<input type="hidden" name="selected_members" id="js-member-ids">
												<input type="hidden" value="<?php echo e($date); ?>" id="js-date" name="date">
											</div>
										</div>
										<div class="col-md-4 d-flex align-items-end">
											<div class="form-group">
												<button type="submit" class="d-block btn btn-success"><?php echo e(__('attendance.save_attendance')); ?></button>
											</div>
										</div>
									</div>
								</form>
							</div>
							<div class="table-responsive mt-2">
								<table class="table custom-table-bordered table-hover mb-0">
									<thead>
										<tr>
											<th class="nowrap align-middle text-center">
												<div class="icheck-primary">
													<input type="checkbox" id="js-select-all" />
													<label for="js-select-all"></label>
												</div>
											</th>
											<th class="nowrap align-middle"><?php echo e(__('attendance.th_photo')); ?></th>
											<th class="nowrap align-middle"><?php echo e(__('attendance.th_name')); ?></th>
											<th class="nowrap align-middle"><?php echo e(__('attendance.th_contact')); ?></th>
											<th class="nowrap align-middle"><?php echo e(__('attendance.th_registration_date')); ?>

											</th>
											<th class="nowrap align-middle"><?php echo e(__('attendance.th_membership_status')); ?>

											</th>
											<th class="nowrap align-middle fixed-width-td"><?php echo e(__('attendance.th_attendance_status')); ?></th>
										</tr>
									</thead>
									<tbody>
										<?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td class="nowrap text-center">
												<div class="icheck-primary">
													<input type="checkbox" class="js-selected-member"
														value="<?php echo e($member->id); ?>" id="status-check-<?php echo e($member->id); ?>" />
													<label for="status-check-<?php echo e($member->id); ?>"></label>
												</div>
											</td>
											<td class="align-middle">
												<div class="img-circle elevation-2 profile-image"
													style="background-image: url('<?php echo e(img_url($member->profile_picture)); ?>');">
												</div>
											</td>
											<td class="align-middle nowrap">
												<?php echo e($member->name); ?>

											</td>
											<td class="align-middle nowrap">
												<?php echo e($member->phone); ?>

											</td>
											<td class="align-middle nowrap">
												<?php echo e(format_date($member->created_at)); ?>

											</td>
											<td class="align-middle nowrap">
												<?php echo membership_status($member->latest_membership->valid_to); ?>

											</td>
											<td class="align-middle nowrap fixed-width-td">
												<?php echo attendance_status($member->attendances); ?>

											</td>
										</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php if(count($members) == 0): ?>
										<tr>
											<td colspan="7">
												<p class="text-center mb-0"><?php echo e(__('attendance.no_record_found')); ?></p>
											</td>
										</tr>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
	$(function () {
		"use strict";
		let memberIds = [];

		$('.js-selected-member').change(function () {
			let e = $('#js-member-ids');
			let attendanceForm = $('#js-attendance-form');
			let searchForm = $('#js-search-form');

			if ($(this).is(':checked')) {
				let value = $(this).val();
				memberIds.push(value);
			} else {
				let value = $(this).val();
				let index = memberIds.indexOf(value);
				if (index !== -1) {
					memberIds.splice(index, 1);
				}
			}

			if (memberIds.length > 0) {
				attendanceForm.removeClass('d-none');
				searchForm.addClass('d-none');
			} else {
				searchForm.removeClass('d-none');
				attendanceForm.addClass('d-none');
			}

			let uniqueItems = Array.from(new Set(memberIds));
			let s = uniqueItems.join(', ');
			e.val(s);
		});

		$('#js-select-all').change(function () {
			memberIds = [];
			let isChecked = $(this).prop('checked');
			$('.js-selected-member').prop('checked', isChecked).trigger('change');
		});

		$('#js-attendance-date').change(function () {
			let date = $(this).val();
			let parsedDate = moment(date, "YYYY-MM-DD");
			let formattedDate = parsedDate.format("DD MMMM YYYY");
			$('#js-selected-date').html(formattedDate);
			$('#js-date').val(date);
		});
	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/attendance/manual.blade.php ENDPATH**/ ?>